;
;***********************
;   DEMO DISPLAY 8*8   *
;     EXPERIMENT 6     *
;***********************
;
         CPU  "8085.TBL"
         HOF  "INT8"
;
PSCAN:   EQU  0B1H
PDATA:   EQU  0B0H
PCTRL:   EQU  0B3H
BLOCK:   EQU  8*1
SCAN:    EQU  2
SYSCAL:  EQU  2
SYSFAG:  EQU  208CH
SDISPY:  EQU  2076H
;
         ORG  2100H
;
;***********************
;     MAIN PROGRAM     *
;***********************

MAIN:    MVI  A,88H
         OUT  PCTRL
;
         LXI  B,BLOCK
         LXI  H,DISBUF
         MVI  M,0
;
MAIN0:   DCX  B
         MOV  A,B
         ORA  C
         JNZ  MAIN0
         CALL CLRDSP
;
         CALL F_DISPY
         LDA  SYSFAG
         ORI  00010000B
         STA  SYSFAG
MAIN00:  MVI  A,SCAN
         RST  SYSCAL
         CPI  11H
         JZ   MAINR
         CPI  13H
         JNZ  MAIN00
         CALL G_DEMO

MAINR:   CALL GCHR
MAIN1:   CALL SHTL
         CALL SHTR
         CALL RTU
         CALL RTD
         CALL LDSP
         CALL RDSP
         JMP  MAIN1
;
;/* Fill display buffer of 7 segment */
;
F_DISPY: LXI  H,TAB_DSP
         LXI  D,SDISPY
         MVI  B,6

F_DIS1:  MOV  A,M
         STAX D
         INX  H
         INX  D
         DCR  B
         JNZ  F_DIS1
         RET
;
;/* Get font of demo */
;
G_DEMO:  LXI  H,TAB_DEM
         LXI  D,COMBUF
G_DEM1:  MOV  A,M
         STAX D
         CPI  0
         INX  H
         INX  D
         JNZ  G_DEM1
         RET

;***********************
;  DISPLAY LEFT&RIGHT  *
;***********************

DSP_LR:  PUSH B
         MVI  B,0BH
;
DSP_LR1: CALL SCAND
         DCR  B
         JNZ  DSP_LR1
         POP  B
         RET
;
;***********************
;   SCAN DISPLAY SUB.  *
;***********************

SCAND:   PUSH PSW
         PUSH B
         PUSH D
         PUSH H

         MVI  B,1
SCD1:    LXI  H,DISPY
         MVI  E,8
;
SCD2:    MOV  A,M
         RLC
         MOV  M,A
         MOV  A,C
         RAL
         MOV  C,A
         DCR  E
         INX  H
         JNZ  SCD2
;
         MOV  A,C
         OUT  PDATA
         MOV  A,B
         OUT  PSCAN
;
         CALL DEL_COL
         MVI  A,0
         OUT  PSCAN
         MOV  A,B
         RLC
         MOV  B,A
         JNC  SCD1
;
         POP  H
         POP  D
         POP  B
         POP  PSW
         RET
;
;***********************
;      DELAY COLUMN    *
;***********************

DEL_COL: XRA  A
DEL_C1:  NOP
         DCR  A
         JNZ  DEL_C1
         RET
;
;***********************
;   CLEAR DISPLAY BUF  *
;***********************

CLRDSP:  LXI  B,BLOCK
         LXI  H,DISPY
;
CLRD1:   MVI  M,0
         INX  H
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  CLRD1
         RET
;
;***********************
;   SHIFT LEFT DISPLAY *
;***********************

SHTL:    CALL GLENT
         LXI  H,DISBUF
         SHLD TEMP
;
SHTL0:   MVI  D,0
         LXI  H,BLOCK
         MOV  A,L
         SUB  C
         MOV  L,A
         MOV  A,H
         SBB  B
         MOV  H,B
         JNC  SHTL1
         LHLD TEMP
         MOV  D,M
;
SHTL1:   LXI  H,DISPY+BLOCK-1
         PUSH B
         MVI  B,BLOCK
;
SHTL2:   MOV  A,M
         MOV  M,D
         MOV  D,A
         DCX  H
         DCR  B
         JNZ  SHTL2
         CALL DSP_LR
         LHLD TEMP
         INX  H
         SHLD TEMP
         POP  B
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  SHTL0
         RET
;
;***********************
;  SHIFT RIGHT DISPLAY *
;***********************

SHTR:    LHLD BLENT
         PUSH H
         POP  D
         LXI  H,DISBUF
         DAD  D
         DCX  H
         SHLD TEMP
         CALL GLENT
;
SHTR0:   MVI  D,0
         LXI  H,BLOCK
         MOV  A,L
         SUB  C
         MOV  L,A
         MOV  A,H
         SBB  B
         MOV  H,B
         JNC  SHTR1
         LHLD TEMP
         MOV  D,M
;
SHTR1:   LXI  H,DISPY
         PUSH B
         MVI  B,8
;
SHTR2:   MOV  A,M
         MOV  M,D
         MOV  D,A
         INX  H
         DCR  B
         JNZ  SHTR2
         CALL DSP_LR
         LHLD TEMP
         DCX  H
         SHLD TEMP
         POP  B
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  SHTR0
         RET
;
;***********************
;     GET CHARACTER    *
;***********************

GCHR:    LXI  H,COMBUF
         SHLD TEMP
         LXI  D,DISBUF
;
GCHR1:   LHLD TEMP
         MOV  A,M
         ORA  A
         JZ   GCHRX

         SUI  20H
         MOV  L,A
         MVI  H,0
         DAD  H
         DAD  H
         DAD  H
         LXI  B,FONT
         DAD  B
         CALL FONT_COV
         MVI  B,8
;
GCHR2:   MOV  A,M
         STAX D
         INX  H
         INX  D
         DCR  B
         JNZ  GCHR2
         LHLD TEMP
         INX  H
         SHLD TEMP
         JMP  GCHR1
;
;/* EXIT FOR GET FONT */

GCHRX:   LHLD TEMP
         LXI  B,COMBUF
         MOV  A,L
         SUB  C
         MOV  L,A
         MOV  A,H
         SBB  B
         MOV  H,A
         DAD  H
         DAD  H
         DAD  H
         SHLD BLENT
         RET
;
;***********************
;      GET LENGTH      *
;***********************

GLENT:   LHLD BLENT
         LXI  D,BLOCK
         DAD  D
         PUSH H
         POP  B
         RET
;
;***********************
;       FONT CONVERT   *
;***********************

FONT_COV:
         PUSH D
         LXI  D,CHR_BUF
         MVI  B,8
;
FONT_C1: MOV  A,M
         STAX D
         INX  H
         INX  D
         DCR  B
         JNZ  FONT_C1
         LXI  D,CHR_BUF1
         MVI  B,8
;
FONT_1:  PUSH D
         LXI  H,CHR_BUF
         MVI  C,8
;
FONT_2:  MOV  A,M
         RLC
         MOV  M,A
         MOV  A,D
         RAL
         MOV  D,A
         INX  H
         DCR  C
         JNZ  FONT_2

         MOV  A,D
         POP  D
         STAX D
         INX  D
         DCR  B
         JNZ  FONT_1
         POP  D
         LXI  H,CHR_BUF1
         RET
;
;***********************
; LOAD CHARACTER TO DSP*
;***********************

LDIS:    LXI  H,DISBUF
         LXI  B,BLOCK
         LXI  D,DISPY
;
LDIS1:   MOV  A,M
         STAX D
         INX  H
         INX  D
         DCX  B
         MOV  A,B
         ORA  C
         JNZ  LDIS1
         RET
;
;***********************
;   ROTATE UP DISPLAY  *
;***********************

RTU:     CALL LDIS
         MVI  C,8
;
RTU1:    LXI  H,DISPY
         MVI  B,8
;
RTU2:    MOV  A,M
         RLC
         MOV  M,A
         INX  H
         DCR  B
         JNZ  RTU2
         CALL DSP_UD
         DCR  C
         JNZ  RTU1
         RET
;
;***********************
;  ROTATE DOWN DISPLAY *
;***********************

RTD:     CALL LDIS
         MVI  C,8
;
RTD1:    LXI  H,DISPY
         MVI  B,8
;
RTD2:    MOV  A,M
         RRC
         MOV  M,A
         INX  H
         DCR  B
         JNZ  RTD2
         CALL DSP_UD
         DCR  C
         JNZ  RTD1
         RET
;
;***********************
;   DISPLAY UP&DOWN    *
;***********************

DSP_UD:  PUSH B
         MVI  B,20H
;
DSP_UD1: CALL SCAND
         DCR  B
         JNZ  DSP_UD1
         POP  B
         RET
;
;***********************
; DISPLAY LEFT NO SHIFT*
;***********************

LDSP:    CALL CLRDSP
         LXI  H,DISBUF+BLOCK-1
         LXI  D,DISPY+BLOCK-1
         MVI  B,BLOCK
;
LDSP1:   MOV  A,M
         STAX D
         CALL DSP_LR
         DCX  H
         DCX  D
         DCR  B
         JNZ  LDSP1
         RET
;
;************************
; DISPLAY RIGHT NO SHIFT*
;************************

RDSP:    CALL CLRDSP
         LXI  H,DISBUF
         LXI  D,DISPY
         MVI  B,BLOCK
;
RDSP1:   MOV  A,M
         STAX D
         CALL DSP_LR
         INX  H
         INX  D
         DCR  B
         JNZ  RDSP1
         RET
;
TAB_DSP:    DFB 77H,3EH,78H,5CH,40H,5EH            ;AUTO-d
TAB_DEM:    DFB "TEST",0

FONT:    DFB 00H,00H,00H,00H
         DFB 00H,00H,00H,00H    ;

         DFB 10H,10H,10H,10H
         DFB 00H,00H,10H,00H    ; !

         DFB 28H,28H,28H,00H
         DFB 00H,00H,00H,00H    ; "

         DFB 28H,28H,7CH,28H
         DFB 7CH,28H,28H,00H    ; #

         DFB 10H,3CH,50H,38H
         DFB 14H,78H,10H,00H    ; $

         DFB 60H,64H,08H,10H
         DFB 20H,4CH,0CH,00H    ; %

         DFB 30H,48H,50H,20H
         DFB 54H,48H,34H,00H    ; &

         DFB 30H,10H,20H,00H
         DFB 00H,00H,00H,00H    ; '

         DFB 08H,10H,20H,20H
         DFB 20H,10H,08H,00H    ; (

         DFB 20H,10H,08H,08H
         DFB 08H,10H,20H,00H    ; )

         DFB 00H,10H,54H,38H
         DFB 54H,10H,00H,00H    ; *

         DFB 00H,10H,10H,7CH
         DFB 10H,10H,00H,00H    ; +

         DFB 00H,00H,00H,00H
         DFB 30H,10H,20H,00H    ; ,

         DFB 00H,00H,00H,7CH
         DFB 00H,00H,00H,00H    ; -

         DFB 00H,00H,00H,00H
         DFB 00H,30H,30H,00H    ; .

         DFB 00H,04H,08H,10H
         DFB 20H,40H,00H,00H    ; /

         DFB 38H,44H,4CH,54H
         DFB 64H,44H,38H,00H    ; 0

         DFB 10H,30H,10H,10H
         DFB 10H,10H,38H,00H    ; 1

         DFB 38H,44H,04H,08H
         DFB 10H,20H,7CH,00H    ; 2

         DFB 7CH,08H,10H,08H
         DFB 04H,44H,38H,00H    ; 3

         DFB 08H,18H,28H,48H
         DFB 7CH,08H,08H,00H    ; 4

         DFB 7CH,40H,78H,04H
         DFB 04H,44H,38H,00H    ; 5

         DFB 18H,20H,40H,78H
         DFB 44H,44H,38H,00H    ; 6

         DFB 7CH,04H,08H,10H
         DFB 20H,20H,20H,00H    ; 7

         DFB 38H,44H,44H,38H
         DFB 44H,44H,38H,00H    ; 8

         DFB 38H,44H,44H,3CH
         DFB 04H,08H,30H,00H    ; 9

         DFB 00H,30H,30H,00H
         DFB 30H,30H,00H,00H    ; :

         DFB 00H,30H,30H,00H
         DFB 30H,10H,20H,00H    ; ;

         DFB 08H,10H,20H,40H
         DFB 20H,10H,08H,00H    ; <

         DFB 00H,00H,7CH,00H
         DFB 7CH,00H,00H,00H    ; =

         DFB 20H,10H,08H,04H
         DFB 08H,10H,20H,00H    ; >

         DFB 38H,44H,04H,08H
         DFB 10H,00H,10H,00H    ; ?

         DFB 38H,44H,04H,34H
         DFB 54H,54H,38H,00H    ; @

         DFB 38H,44H,44H,44H
         DFB 7CH,44H,44H,00H    ; A

         DFB 78H,44H,44H,78H
         DFB 44H,44H,78H,00H    ; B

         DFB 38H,44H,40H,40H
         DFB 40H,44H,38H,00H    ; C

         DFB 70H,48H,44H,44H
         DFB 44H,48H,70H,00H    ; D

         DFB 7CH,40H,40H,78H
         DFB 40H,40H,7CH,00H    ; E

         DFB 7CH,40H,40H,78H
         DFB 40H,40H,40H,00H    ; F

         DFB 38H,44H,40H,5CH
         DFB 44H,44H,3CH,00H    ; G

         DFB 44H,44H,44H,7CH
         DFB 44H,44H,44H,00H    ; H

         DFB 38H,10H,10H,10H
         DFB 10H,10H,38H,00H    ; I

         DFB 1CH,08H,08H,08H
         DFB 08H,48H,30H,00H    ; J

         DFB 44H,48H,50H,60H
         DFB 50H,48H,44H,00H    ; K

         DFB 40H,40H,40H,40H
         DFB 40H,40H,7CH,00H    ; L

         DFB 44H,6CH,54H,54H
         DFB 44H,44H,44H,00H    ; M

         DFB 44H,44H,64H,54H
         DFB 4CH,44H,44H,00H    ; N

         DFB 38H,44H,44H,44H
         DFB 44H,44H,38H,00H    ; O

         DFB 78H,44H,44H,78H
         DFB 40H,40H,40H,00H    ; P

         DFB 38H,44H,44H,44H
         DFB 54H,48H,34H,00H    ; Q

         DFB 78H,44H,44H,78H
         DFB 50H,48H,44H,00H    ; R

         DFB 3CH,40H,40H,38H
         DFB 04H,04H,78H,00H    ; S

         DFB 7CH,10H,10H,10H
         DFB 10H,10H,10H,00H    ; T

         DFB 44H,44H,44H,44H
         DFB 44H,44H,38H,00H    ; U

         DFB 44H,44H,44H,44H
         DFB 44H,28H,10H,00H    ; V

         DFB 44H,44H,44H,54H
         DFB 54H,54H,28H,00H    ; W

         DFB 44H,44H,28H,10H
         DFB 28H,44H,44H,00H    ; X

         DFB 44H,44H,44H,28H
         DFB 10H,10H,10H,00H    ; Y

         DFB 7CH,04H,08H,10H
         DFB 20H,40H,7CH,00H    ; Z

         DFB 38H,20H,20H,20H
         DFB 20H,20H,38H,00H    ; [

         DFB 40H,20H,10H,08H
         DFB 04H,02H,01H,00H    ; \

         DFB 38H,08H,08H,08H
         DFB 08H,08H,38H,00H    ; ]

         DFB 10H,28H,44H,00H
         DFB 00H,00H,00H,00H    ; ^

         DFB 00H,00H,00H,00H
         DFB 00H,00H,7CH,00H    ; _

         DFB 20H,10H,08H,00H
         DFB 00H,00H,00H,00H    ;`

         DFB 00H,00H,38H,08H
         DFB 38H,48H,34H,00H    ; a

         DFB 40H,40H,58H,64H
         DFB 44H,44H,78H,00H    ; b

         DFB 00H,00H,3CH,40H
         DFB 40H,40H,3CH,00H    ; c

         DFB 04H,04H,34H,4CH
         DFB 44H,44H,3CH,00H    ; d

         DFB 00H,00H,38H,44H
         DFB 78H,40H,38H,00H    ; e

         DFB 18H,24H,20H,70H
         DFB 20H,20H,20H,00H    ; f

         DFB 00H,00H,38H,44H
         DFB 44H,3CH,04H,38H    ; g

         DFB 40H,40H,58H,64H
         DFB 44H,44H,44H,00H    ; h

         DFB 10H,00H,30H,10H
         DFB 10H,10H,38H,00H    ; i

         DFB 00H,08H,00H,08H
         DFB 08H,28H,10H,00H    ; j

         DFB 40H,40H,48H,50H
         DFB 60H,50H,48H,00H    ; k

         DFB 30H,10H,10H,10H
         DFB 10H,10H,18H,00H    ; l

         DFB 00H,00H,68H,54H
         DFB 54H,54H,44H,00H    ; m

         DFB 00H,00H,58H,24H
         DFB 24H,24H,24H,00H    ; n

         DFB 00H,00H,38H,44H
         DFB 44H,44H,38H,00H    ; o

         DFB 00H,00H,70H,48H
         DFB 48H,70H,40H,40H    ; p

         DFB 00H,00H,38H,48H
         DFB 48H,38H,08H,08H    ; q

         DFB 00H,00H,58H,64H
         DFB 40H,40H,40H,00H    ; r

         DFB 00H,00H,38H,40H
         DFB 38H,04H,78H,00H    ; s

         DFB 20H,20H,78H,20H
         DFB 20H,24H,18H,00H    ; t

         DFB 00H,00H,48H,48H
         DFB 48H,48H,34H,00H    ; u

         DFB 00H,00H,44H,44H
         DFB 28H,28H,10H,00H    ; v

         DFB 00H,00H,44H,44H
         DFB 54H,54H,28H,00H    ; w

         DFB 00H,00H,44H,28H
         DFB 10H,28H,44H,00H    ; x

         DFB 00H,00H,48H,48H
         DFB 48H,38H,08H,70H    ; y

         DFB 00H,00H,7CH,08H
         DFB 10H,20H,7CH,00H    ; z

         DFB 08H,10H,10H,20H
         DFB 10H,10H,08H,00H    ; {

         DFB 18H,18H,18H,18H
         DFB 18H,18H,18H,00H    ; |

         DFB 20H,10H,10H,08H
         DFB 10H,10H,20H,00H    ; }

         DFB 00H,00H,00H,32H
         DFB 4CH,00H,00H,00H    ; ~


           ORG  3000H

COMBUF:    DFS   100
DISBUF:    DFS   8*100
DISPY:     DFS   BLOCK
CHR_BUF:   DFS   8
CHR_BUF1:  DFS   8
BLENT:     DFS   2
SPEED:     DFS   1
TEMP:      DFS   2
;

